#version=DEVEL
# X Window System configuration information
xconfig  --startxonboot
# Keyboard layouts
keyboard 'us'
# Root password
rootpw --plaintext rootme
# System language
lang en_US.UTF-8
# Shutdown after installation
shutdown
# System timezone
timezone US/Eastern
# Network information
network  --bootproto=dhcp --device=link --activate

# Repos
#url --url=https://repo.almalinux.org/almalinux/10/BaseOS/$basearch/os/
#repo --name="appstream" --baseurl=https://repo.almalinux.org/almalinux/10/AppStream/$basearch/os/
#repo --name="extras" --baseurl=https://repo.almalinux.org/almalinux/10/extras/$basearch/os/
#repo --name="crb" --baseurl=https://repo.almalinux.org/almalinux/10/CRB/$basearch/os/
#repo --name="epel" --baseurl=https://dl.fedoraproject.org/pub/epel/10z/Everything/$basearch/

# Repos
url --url=http://192.168.1.4/almalinux/10/BaseOS/x86_64/os/
repo --name="appstream" --baseurl=http://192.168.1.4/almalinux/10/AppStream/x86_64/os/
repo --name="extras" --baseurl=http://192.168.1.4/almalinux/10/extras/x86_64/os/
repo --name="crb" --baseurl=http://192.168.1.4/almalinux/10/CRB/x86_64/os/
repo --name="epel" --baseurl=http://192.168.1.4/epel/10/Everything/x86_64/
repo --name="rpmfusionfree" --baseurl=http://192.168.1.4/rpmfusion/updates/10/free/x86_64/
repo --name="rpmfusionnonfree" --baseurl=http://192.168.1.4/rpmfusion/updates/10/nonfree/x86_64/
repo --name="local" --baseurl=http://192.168.1.4/local/10/x86_64/

# Firewall configuration
firewall --enabled --service=mdns
# SELinux configuration
selinux --enforcing

# System services
services --disabled="sshd" --enabled="NetworkManager,ModemManager"
# System bootloader configuration
bootloader --location=none
# Clear the Master Boot Record
zerombr
# Partition clearing information
clearpart --all --initlabel
# Disk partitioning information
part / --size=10238

%post

# Enable livesys services
systemctl enable livesys.service
systemctl enable livesys-late.service

# Enable sddm since EPEL packages it disabled by default
systemctl enable sddm.service

# enable tmpfs for /tmp
systemctl enable tmp.mount

# make it so that we don't do writing to the overlay for things which
# are just tmpdirs/caches
# note https://bugzilla.redhat.com/show_bug.cgi?id=1135475
cat >> /etc/fstab << EOF
vartmp   /var/tmp    tmpfs   defaults   0  0
EOF

# work around for poor key import UI in PackageKit
rm -f /var/lib/rpm/__db*
# import AlmaLinux PGP key
rpm --import /etc/pki/rpm-gpg/RPM-GPG-KEY-AlmaLinux
echo "Packages within this LiveCD"
rpm -qa
# Note that running rpm recreates the rpm db files which aren't needed or wanted
rm -f /var/lib/rpm/__db*

# go ahead and pre-make the man -k cache (#455968)
/usr/bin/mandb

# make sure there aren't core files lying around
rm -f /core*

# remove random seed, the newly installed instance should make it's own
rm -f /var/lib/systemd/random-seed

# convince readahead not to collect
# FIXME: for systemd

echo 'File created by kickstart. See systemd-update-done.service(8).' \
    | tee /etc/.updated >/var/.updated

# Drop the rescue kernel and initramfs, we don't need them on the live media itself.
# See bug 1317709
rm -f /boot/*-rescue*

# Theme wallpapers
rm -f /usr/share/wallpapers/Fedora
ln -s Alma-default /usr/share/wallpapers/Fedora

# Login screen theme and wallpapers
cat <<'EOF'>/etc/sddm.conf.d/kde_settings.conf
[Theme]
Current=breeze
EOF
sed -i 's#background=.*$#background=/usr/share/backgrounds/almalinux-day.jpg#g' \
  /usr/share/sddm/themes/breeze/theme.conf

# TODO: revise I and II once installer icon is on the separate package
# like Fedora does at https://src.fedoraproject.org/rpms/kf6-breeze-icons/c/728493c525b4e4e7be5caccba41f66e8d816ee38

# I. Fix org.fedoraproject.AnacondaInstaller.svg broken symlinks
cp -a /usr/share/icons/hicolor/scalable/apps/org.fedoraproject.AnacondaInstaller.svg \
  /usr/share/icons/hicolor/48x48/apps/
# II. Replace live installer icon for the application and welcome center
cp -a /usr/share/icons/hicolor/scalable/apps/org.fedoraproject.AnacondaInstaller.svg \
  /usr/share/icons/hicolor/48x48/apps/org.almalinux.AnacondaInstaller.svg
sed -i 's#Icon=.*$#Icon=org.almalinux.AnacondaInstaller#g' \
  /usr/share/applications/liveinst.desktop

# Show liveinst.desktop on desktop and in menu
sed -i 's/NoDisplay=true/NoDisplay=false/' /usr/share/applications/liveinst.desktop
mkdir /home/liveuser/Desktop
cp -a /usr/share/applications/liveinst.desktop /home/liveuser/Desktop/liveinst.desktop
chmod +x /home/liveuser/Desktop/liveinst.desktop

# Disable network service here, as doing it in the services line
# fails due to RHBZ #1369794
systemctl disable network

# Remove machine-id on pre generated images
rm -f /etc/machine-id
touch /etc/machine-id

# set livesys session type
sed -i 's/^livesys_session=.*/livesys_session="kde"/' /etc/sysconfig/livesys

# enable CRB repo
dnf config-manager --enable crb

# Workaround to add openvpn user and group in case they didn't added during
# openvpn package installation
getent group openvpn &>/dev/null || groupadd -r openvpn
getent passwd openvpn &>/dev/null || \
    /usr/sbin/useradd -r -g openvpn -s /sbin/nologin -c OpenVPN \
        -d /etc/openvpn openvpn

%end

%packages
aardvark-dns
accounts-qml-module-qt6
accountsservice
acl
adcli
adobe-mappings-cmap
adobe-mappings-cmap-deprecated
adobe-mappings-pdf
adwaita-cursor-theme
adwaita-icon-theme
aha
akonadi-server
akonadi-server-mysql
almalinux-backgrounds
almalinux-backgrounds-extras
almalinux-gpg-keys
almalinux-indexhtml
almalinux-logos
almalinux-release
almalinux-repos
alsa-lib
alsa-sof-firmware
alsa-ucm
alsa-utils
alternatives
amd-gpu-firmware
amd-ucode-firmware
anaconda
anaconda-core
anaconda-gui
anaconda-install-env-deps
anaconda-live
anaconda-tui
anaconda-widgets
anthy-unicode
appstream
appstream-data
appstream-qt
aribb24
ark
ark-libs
at
atheros-firmware
atk
at-spi2-atk
at-spi2-core
attr
audiocd-kio
audiocd-kio-doc
audit
audit-libs
audit-rules
authselect
authselect-libs
avahi
avahi-glib
avahi-libs
baloo-widgets
basesystem
bash
bash-color-prompt
bash-completion
bc
bind-libs
bind-license
bind-utils
binutils
binutils-gold
blivet-data
blktrace
bluedevil
bluez
bluez-libs
bluez-obexd
bolt
boost-regex
bpftool
brcmfmac-firmware
breeze-cursor-theme
breeze-gtk-common
breeze-gtk-gtk3
breeze-gtk-gtk4
breeze-icon-theme
brlapi
brltty
bubblewrap
bzip2
bzip2-libs
ca-certificates
cairo
cairo-gobject
c-ares
catatonit
cdparanoia-libs
cfitsio
checkpolicy
chrony
cirrus-audio-firmware
cldr-emoji-annotation
cldr-emoji-annotation-dtd
clevis
clevis-luks
clevis-pin-tpm2
clinfo
cmake-filesystem
cockpit
cockpit-bridge
cockpit-packagekit
cockpit-storaged
cockpit-system
cockpit-ws
codec2
colord
colord-kde
colord-libs
color-filesystem
compat-lua-libs
composefs-libs
conmon
containers-common
containers-common-extra
container-selinux
coreutils
coreutils-common
cpio
cpp
cpuinfo
cracklib
cracklib-dicts
criu
criu-libs
cronie
cronie-anacron
crontabs
crun
crypto-policies
crypto-policies-scripts
cryptsetup
cryptsetup-libs
cups
cups-browsed
cups-client
cups-filesystem
cups-filters
cups-filters-driverless
cups-ipptool
cups-libs
cups-pk-helper
curl
cxl-libs
cyrus-sasl-gssapi
cyrus-sasl-lib
cyrus-sasl-plain
daxctl-libs
dbus
dbus-broker
dbus-common
dbus-daemon
dbus-libs
dbus-tools
dbus-x11
dconf
ddcutil
ddrescue
default-fonts-am
default-fonts-ar
default-fonts-as
default-fonts-ast
default-fonts-be
default-fonts-bg
default-fonts-bn
default-fonts-bo
default-fonts-br
default-fonts-chr
default-fonts-cjk-mono
default-fonts-cjk-sans
default-fonts-cjk-serif
default-fonts-core-emoji
default-fonts-core-math
default-fonts-core-mono
default-fonts-core-sans
default-fonts-core-serif
default-fonts-dv
default-fonts-dz
default-fonts-el
default-fonts-eo
default-fonts-eu
default-fonts-fa
default-fonts-gu
default-fonts-he
default-fonts-hi
default-fonts-hy
default-fonts-ia
default-fonts-iu
default-fonts-ka
default-fonts-km
default-fonts-kn
default-fonts-ku
default-fonts-lo
default-fonts-mai
default-fonts-ml
default-fonts-mni
default-fonts-mr
default-fonts-my
default-fonts-nb
default-fonts-ne
default-fonts-nn
default-fonts-nr
default-fonts-nso
default-fonts-or
default-fonts-other-mono
default-fonts-other-sans
default-fonts-other-serif
default-fonts-pa
default-fonts-ru
default-fonts-sat
default-fonts-si
default-fonts-ss
default-fonts-ta
default-fonts-te
default-fonts-th
default-fonts-tn
default-fonts-ts
default-fonts-uk
default-fonts-ur
default-fonts-ve
default-fonts-vi
default-fonts-xh
default-fonts-yi
default-fonts-zu
dejavu-sans-fonts
dejavu-sans-mono-fonts
dejavu-serif-fonts
desktop-file-utils
device-mapper
device-mapper-event
device-mapper-event-libs
device-mapper-libs
device-mapper-multipath
device-mapper-multipath-libs
device-mapper-persistent-data
diffutils
dmidecode
dnf
dnf-data
dnf-plugins-core
dnsmasq
docbook-dtds
docbook-style-xsl
dolphin
dolphin-libs
dolphin-plugins
dos2unix
dosfstools
dotconf
double-conversion
dracut
dracut-config-rescue
dracut-live
dracut-network
dracut-squash
dragon
duktape
e2fsprogs
e2fsprogs-libs
ebook-tools-libs
ed
editorconfig-libs
efibootmgr
efi-filesystem
efivar-libs
egl-utils
elfutils-debuginfod-client
elfutils-default-yama-scope
elfutils-libelf
elfutils-libs
elinks
elisa-player
emacs-filesystem
enchant2
enscript
epel-release
erofs-utils
espeak-ng
ethtool
exfatprogs
exiv2
exiv2-libs
expat
f41-backgrounds-base
f41-backgrounds-kde
faad2-libs
fdk-aac-free
ffmpeg
ffmpeg-libs
ffmpegthumbs
fftw-libs-double
file
file-libs
filelight
filesystem
findutils
firefox
firewall-config
firewalld
firewalld-filesystem
flac-libs
flashrom
flatpak
flatpak-kcm
flatpak-libs
flatpak-selinux
flatpak-session-helper
fontconfig
fonts-filesystem
foomatic
foomatic-db
foomatic-db-filesystem
foomatic-db-ppds
fprintd
fprintd-pam
freeglut
freerdp
freerdp2-libs
freerdp-libs
freetype
fribidi
fstrm
fuse
fuse3
fuse3-libs
fuse-common
fuse-libs
fuse-sshfs
fwupd
fwupd-efi
fwupd-plugin-flashrom
game-music-emu
gawk
gawk-all-langpacks
gcr-libs
gd
gdb
gdb-headless
gdbm
gdbm-libs
gdk-pixbuf2
gdk-pixbuf2-modules
geoclue2
gettext-envsubst
gettext-libs
gettext-runtime
ghostscript
ghostscript-tools-fonts
ghostscript-tools-printing
giflib
glib2
glibc
glibc-all-langpacks
glibc-common
glibc-gconv-extra
glib-networking
glx-utils
gmp
gnome-menus
gnupg2
gnupg2-smime
gnutls
gobject-introspection
google-droid-sans-fonts
google-noto-color-emoji-fonts
google-noto-fonts-common
google-noto-naskh-arabic-vf-fonts
google-noto-sans-arabic-vf-fonts
google-noto-sans-armenian-vf-fonts
google-noto-sans-bengali-vf-fonts
google-noto-sans-canadian-aboriginal-vf-fonts
google-noto-sans-cherokee-vf-fonts
google-noto-sans-cjk-vf-fonts
google-noto-sans-devanagari-vf-fonts
google-noto-sans-ethiopic-vf-fonts
google-noto-sans-fonts
google-noto-sans-georgian-vf-fonts
google-noto-sans-gujarati-vf-fonts
google-noto-sans-gurmukhi-vf-fonts
google-noto-sans-hebrew-vf-fonts
google-noto-sans-kannada-vf-fonts
google-noto-sans-khmer-vf-fonts
google-noto-sans-lao-vf-fonts
google-noto-sans-math-fonts
google-noto-sans-meetei-mayek-vf-fonts
google-noto-sans-mono-cjk-vf-fonts
google-noto-sans-mono-fonts
google-noto-sans-mono-vf-fonts
google-noto-sans-ol-chiki-vf-fonts
google-noto-sans-oriya-vf-fonts
google-noto-sans-sinhala-vf-fonts
google-noto-sans-symbols-2-fonts
google-noto-sans-symbols-vf-fonts
google-noto-sans-tamil-vf-fonts
google-noto-sans-telugu-vf-fonts
google-noto-sans-thaana-vf-fonts
google-noto-sans-thai-vf-fonts
google-noto-sans-vf-fonts
google-noto-serif-armenian-vf-fonts
google-noto-serif-bengali-vf-fonts
google-noto-serif-cjk-vf-fonts
google-noto-serif-devanagari-vf-fonts
google-noto-serif-ethiopic-vf-fonts
google-noto-serif-fonts
google-noto-serif-georgian-vf-fonts
google-noto-serif-gujarati-vf-fonts
google-noto-serif-gurmukhi-vf-fonts
google-noto-serif-hebrew-vf-fonts
google-noto-serif-kannada-vf-fonts
google-noto-serif-khmer-vf-fonts
google-noto-serif-lao-vf-fonts
google-noto-serif-oriya-vf-fonts
google-noto-serif-sinhala-vf-fonts
google-noto-serif-tamil-vf-fonts
google-noto-serif-telugu-vf-fonts
google-noto-serif-thai-vf-fonts
google-noto-serif-vf-fonts
gpgme
gpgmepp
gpsd-libs
graphene
graphite2
grep
groff-base
grub2-common
grub2-efi-x64
grub2-efi-x64-cdboot
grub2-pc
grub2-pc-modules
grub2-tools
grub2-tools-efi
grub2-tools-extra
grub2-tools-minimal
grubby
gsettings-desktop-schemas
gsm
gstreamer1
gstreamer1-plugins-bad-free
gstreamer1-plugins-bad-free-libs
gstreamer1-plugins-bad-freeworld
gstreamer1-plugins-base
gstreamer1-plugins-good
gstreamer1-plugins-ugly
gstreamer1-plugins-ugly-free
gtk3
gtk3-immodule-xim
gtk4
gtk-update-icon-cache
gutenprint
gutenprint-cups
gutenprint-doc
gutenprint-libs
gwenview
gwenview-libs
gzip
harfbuzz
hdparm
hicolor-icon-theme
highway
hostname
hunspell
hunspell-en
hunspell-en-GB
hunspell-en-US
hunspell-filesystem
hwdata
hyperv-daemons
hyperv-daemons-license
hypervfcopyd
hypervkvpd
hypervvssd
i2c-tools
ibus
ibus-anthy
ibus-anthy-python
ibus-gtk3
ibus-gtk4
ibus-hangul
ibus-libpinyin
ibus-libs
ibus-libzhuyin
ibus-m17n
ibus-setup
ibus-typing-booster
iio-sensor-proxy
ilbc
ima-evm-utils
inih
inih-cpp
iniparser
initscripts-rename-device
initscripts-service
intel-audio-firmware
intel-gpu-firmware
intel-vpl-gpu-rt
ipp-usb
iproute
iproute-tc
ipset
ipset-libs
iptables-libs
iptables-nft
iputils
irqbalance
iscsi-initiator-utils
iscsi-initiator-utils-iscsiuio
isns-utils-libs
iso-codes
isomd5sum
iw
iwlwifi-dvm-firmware
iwlwifi-mvm-firmware
jansson
jasper-libs
jbig2dec-libs
jbigkit-libs
jomolhari-fonts
jose
jq
json-c
json-glib
jxl-pixbuf-loader
kaccounts-integration-qt6
kaccounts-providers
kactivitymanagerd
kamera
kasumi-common
kasumi-unicode
kate-libs
kbd
kbd-legacy
kbd-misc
kcalc
kcharselect
kcolorpicker-qt6
kdebugsettings
kde-cli-tools
kdecoration
kde-filesystem
kdegraphics-mobipocket
kdegraphics-thumbnailers
kde-gtk-config
kde-inotify-survey
kdenetwork-filesharing
kde-partitionmanager
kdeplasma-addons
kde-settings
kde-settings-plasma
kde-settings-pulseaudio
kde-settings-sddm
kdesu
kdialog
kdnssd
kdsoap6
kdsoap-ws-discovery-client
kdump-anaconda-addon
kdump-utils
keditbookmarks
keditbookmarks-libs
kernel
kernel-core
kernel-modules
kernel-modules-core
kernel-modules-extra
kernel-tools
kernel-tools-libs
kexec-tools
keyutils
keyutils-libs
kf6-attica
kf6-baloo
kf6-baloo-file
kf6-baloo-libs
kf6-bluez-qt
kf6-breeze-icons
kf6-filesystem
kf6-frameworkintegration
kf6-frameworkintegration-libs
kf6-karchive
kf6-kauth
kf6-kbookmarks
kf6-kcalendarcore
kf6-kcmutils
kf6-kcodecs
kf6-kcolorscheme
kf6-kcompletion
kf6-kconfig
kf6-kconfigwidgets
kf6-kcontacts
kf6-kcoreaddons
kf6-kcrash
kf6-kdbusaddons
kf6-kdeclarative
kf6-kded
kf6-kdesu
kf6-kdnssd
kf6-kdoctools
kf6-kfilemetadata
kf6-kglobalaccel
kf6-kguiaddons
kf6-kholidays
kf6-ki18n
kf6-kiconthemes
kf6-kidletime
kf6-kimageformats
kf6-kio-core
kf6-kio-core-libs
kf6-kio-doc
kf6-kio-file-widgets
kf6-kio-gui
kf6-kio-widgets
kf6-kio-widgets-libs
kf6-kirigami
kf6-kirigami-addons
kf6-kitemmodels
kf6-kitemviews
kf6-kjobwidgets
kf6-knewstuff
kf6-knotifications
kf6-knotifyconfig
kf6-kpackage
kf6-kparts
kf6-kpty
kf6-kquickcharts
kf6-krunner
kf6-kservice
kf6-kstatusnotifieritem
kf6-ksvg
kf6-ktexteditor
kf6-ktexttemplate
kf6-ktextwidgets
kf6-kunitconversion
kf6-kuserfeedback
kf6-kwallet
kf6-kwallet-libs
kf6-kwidgetsaddons
kf6-kwindowsystem
kf6-kxmlgui
kf6-modemmanager-qt
kf6-networkmanager-qt
kf6-prison
kf6-purpose
kf6-qqc2-desktop-style
kf6-solid
kf6-sonnet
kf6-sonnet-hunspell
kf6-syndication
kf6-syntax-highlighting
kf6-threadweaver
kfind
kglobalacceld
khelpcenter
kimageannotator-common
kimageannotator-qt6
kinfocenter
kio-admin
kio-extras
kio-fuse
kio-gdrive
kjournald
kjournald-libs
kmahjongg
kmenuedit
kmines
kmod
kmod-libs
kmouth
kolourpaint
kolourpaint-libs
konsole
konsole-part
konversation
kpartx
kpatch
kpatch-dnf
kpipewire
kpmcore
kquickimageeditor-qt6
krb5-libs
krdc
krdc-libs
krdp
krdp-libs
krfb
krfb-libs
ksanecore
kscreen
kscreenlocker
ksshaskpass
ksystemstats
kwalletmanager5
kwayland
kwin
kwin-common
kwin-libs
kwin-wayland
kwrite
kwrited
kxkb2locale1
kyotocabinet-libs
ladspa
lame
lame-libs
langpacks-core-en
langpacks-en
langpacks-fonts-en
langtable
layer-shell-qt
lcms2
ldns
ledmon
ledmon-libs
leptonica
less
liba52
libaccounts-glib
libaccounts-qt6
libacl
libadwaita
libaio
libao
libaom
libappindicator-gtk3
libarchive
libaribcaption
libass
libassuan
libasyncns
libatasmart
libatomic
libattr
libavdevice
libavif
libbabeltrace
libbasicobjects
libblkid
libblockdev
libblockdev-crypto
libblockdev-dm
libblockdev-fs
libblockdev-loop
libblockdev-lvm
libblockdev-mdraid
libblockdev-mpath
libblockdev-nvdimm
libblockdev-nvme
libblockdev-part
libblockdev-plugins-all
libblockdev-smart
libblockdev-smartmontools
libblockdev-swap
libblockdev-utils
libbluray
libbpf
libbrotli
libbs2b
libburn
libbytesize
libcaca
libcanberra
libcanberra-gtk3
libcap
libcap-ng
libcap-ng-python3
libcbor
libcdio
libcdio-paranoia
libchewing
libchromaprint
libcollection
libcom_err
libcomps
libconfig
libcupsfilters
libcurl
libdaemon
libdatrie
libdav1d
libdbusmenu
libdbusmenu-gtk3
libddcutil
libde265
libdecor
libdex
libdhash
libdisplay-info
libdisplay-info-tools
libdmtx
libdnf
libdovi
libdrm
libdvdnav
libdvdread
libeconf
libedit
libei
libeis
libepoxy
liberation-fonts-common
liberation-mono-fonts
libertas-firmware
libestr
libevdev
libevent
libexif
libfastjson
libfdisk
libffi
libfido2
libfontenc
libfprint
libgcc
libgcrypt
libgfortran
libglvnd
libglvnd-egl
libglvnd-gles
libglvnd-glx
libglvnd-opengl
libgomp
libgpg-error
libgphoto2
libgs
libgudev
libgusb
libhangul
libheif
libi2c
libibverbs
libical
libICE
libicu
libidn2
libieee1284
libijs
libimobiledevice
libimobiledevice-glue
libini_config
libinput
libipa_hbac
libipt
libisoburn
libisofs
libjcat
libjose
libjpeg-turbo
libjxl
libkcapi
libkcapi-hasher
libkcapi-hmaccalc
libkcddb
libkcddb-doc
libkcompactdisc
libkdcraw
libkdegames
libkexiv2-qt6
libkgapi
libkmahjongg
libkmahjongg-data
libksane
libksba
libkscreen
libksysguard
libksysguard-common
libkworkspace6
liblc3
libldac
libldb
liblerc
liblouis
liblouis-tables
libluksmeta
libmarkdown
libmaxminddb
libmbim
libmbim-utils
libmng
libmnl
libmodplug
libmodulemd
libmount
libmpc
libmpeg2
libmspack
libmtp
libmusicbrainz5
libmysofa
libndp
libnet
libnetapi
libnetfilter_conntrack
libnfnetlink
libnftnl
libnghttp2
libnl3
libnma
libnotify
libnvme
liboeffis
libogg
libopenmpt
libpaper
libpath_utils
libpcap
libpciaccess
libpinyin
libpinyin-data
libpipeline
libpkgconf
libplacebo
libplasma
libplist
libpng
libportal
libppd
libproxy
libproxy-bin
libpskc
libpsl
libpwquality
libqalculate
libqmi
libqmi-utils
libqrtr-glib
LibRaw
libref_array
librelp
librepo
libreswan
librsvg2
librsvg2-tools
librtmp
libsamplerate
libsane-airscan
libsbc
libseccomp
libsecret
libselinux
libselinux-utils
libsemanage
libsepol
libshaderc
libshout
libSM
libsmartcols
libsmbclient
libsndfile
libsodium
libsolv
libsoup3
libspectre
libsrtp
libss
libssh
libssh-config
libsss_certmap
libsss_idmap
libsss_nss_idmap
libsss_sudo
libstdc++
libstoragemgmt
libsysfs
libtalloc
libtasn1
libtdb
libtevent
libthai
libtheora
libtiff
libtirpc
libtool-ltdl
libtraceevent
libtracker-sparql
libudfread
libudisks2
libunibreak
libunistring
libunity-gtk3-parser
libunwind
liburing
libusb1
libusbmuxd
libuser
libutempter
libuuid
libuv
libv4l
libva
libva-intel-driver
libvdpau
libverto
libvmaf
libvncserver
libvorbis
libvpl
libvpx
libwacom
libwacom-data
libwayland-client
libwayland-cursor
libwayland-egl
libwayland-server
libwbclient
libwebp
libwinpr
libwinpr2
libwnck3
libX11
libX11-common
libX11-xcb
libXau
libXaw
libxcb
libXcomposite
libxcrypt
libXcursor
libxcvt
libXdamage
libXdmcp
libXext
libXfixes
libXfont2
libXft
libXi
libXinerama
libxkbcommon
libxkbcommon-x11
libxkbfile
libxml2
libxmlb
libXmu
libXpm
libXrandr
libXrender
libXres
libxshmfence
libxslt
libXt
libXtst
libXv
libXxf86dga
libXxf86vm
libyaml
libzhuyin
libzip
libzstd
lilv-libs
linux-firmware
linux-firmware-whence
livesys-scripts
llvm-libs
lmdb-libs
lm_sensors-libs
lockdev
logrotate
lorax
lorax-templates-rhel
low-memory-monitor
lrzsz
lsb_release
lshw
lsof
lsscsi
lua-libs
luksmeta
lv2
lvm2
lvm2-libs
lz4-libs
lzo
m17n-db
m17n-lib
madan-fonts
mailcap
makedumpfile
maliit-framework
maliit-framework-qt5
maliit-keyboard
man-db
man-pages
mariadb
mariadb-backup
mariadb-client-utils
mariadb-common
mariadb-connector-c
mariadb-connector-c-config
mariadb-errmsg
mariadb-gssapi-server
mariadb-server
mariadb-server-utils
mc
mcelog
mdadm
media-player-info
memstrack
memtest86+
mesa-dri-drivers
mesa-filesystem
mesa-libEGL
mesa-libgbm
mesa-libGL
mesa-libglapi
mesa-libGLU
mesa-vulkan-drivers
microcode_ctl
minicom
mjpegtools-libs
mobile-broadband-provider-info
ModemManager
ModemManager-glib
mokutil
mozilla-filesystem
mpdecimal
mpfr
mpg123-libs
mpv
mt7xxx-firmware
mtdev
mtools
mtr
mujs
mysql-selinux
nano
ncurses
ncurses-base
ncurses-libs
ndctl
ndctl-libs
neon
netavark
netronome-firmware
nettle
net-tools
NetworkManager
NetworkManager-adsl
NetworkManager-bluetooth
NetworkManager-config-connectivity-redhat
NetworkManager-l2tp
NetworkManager-libnm
NetworkManager-libreswan
NetworkManager-openconnect
NetworkManager-openvpn
NetworkManager-pptp
NetworkManager-tui
NetworkManager-wifi
NetworkManager-wwan
newt
nftables
nmap-ncat
nm-connection-editor
noopenh264
npth
nspr
nss
nss-mdns
nss-softokn
nss-softokn-freebl
nss-sysinit
nss-tools
nss-util
ntfs-3g
ntfs-3g-libs
numactl-libs
nvidia-gpu-firmware
nvme-cli
nwipe
nxpwireless-firmware
ocean-sound-theme
ocl-icd
okular
okular-libs
okular-part
oniguruma
openal-soft
openblas
openblas-serial
openconnect
opencore-amr
opencv-core
opencv-imgproc
openexr-libs
openjpeg2
openldap
openpgm
openssh
openssh-askpass
openssh-clients
openssh-server
openssl
openssl-libs
open-vm-tools
open-vm-tools-desktop
openvpn
opus
orc
orca
os-prober
ostree-libs
p11-kit
p11-kit-server
p11-kit-trust
PackageKit
PackageKit-command-not-found
PackageKit-glib
PackageKit-gstreamer-plugin
PackageKit-Qt6
paktype-naskh-basic-fonts
pam
pam-kwallet
pam-libs
pango
paps
parted
passt
passt-selinux
pbzip2
pcaudiolib
pciutils
pciutils-libs
pcre2
pcre2-syntax
pcre2-utf16
pcre2-utf32
pcsc-lite
pcsc-lite-ccid
pcsc-lite-libs
perl-AutoLoader
perl-B
perl-base
perl-Carp
perl-Class-Struct
perl-constant
perl-Data-Dumper
perl-DBD-MariaDB
perl-DBI
perl-Digest
perl-Digest-MD5
perl-DynaLoader
perl-Encode
perl-Errno
perl-Exporter
perl-Fcntl
perl-File-Basename
perl-File-Copy
perl-FileHandle
perl-File-Path
perl-File-stat
perl-File-Temp
perl-Getopt-Long
perl-Getopt-Std
perl-HTTP-Tiny
perl-if
perl-interpreter
perl-IO
perl-IO-Socket-IP
perl-IO-Socket-SSL
perl-IPC-Open3
perl-libnet
perl-libs
perl-locale
perl-Math-BigInt
perl-Math-Complex
perl-MIME-Base64
perl-Mozilla-CA
perl-mro
perl-NDBM_File
perl-Net-SSLeay
perl-overload
perl-overloading
perl-parent
perl-PathTools
perl-Pod-Escapes
perl-podlators
perl-Pod-Perldoc
perl-Pod-Simple
perl-Pod-Usage
perl-POSIX
perl-Scalar-List-Utils
perl-SelectSaver
perl-Socket
perl-Storable
perl-Symbol
perl-Sys-Hostname
perl-Term-ANSIColor
perl-Term-Cap
perl-Text-ParseWords
perl-Text-Tabs+Wrap
perl-Time-Local
perl-URI
perl-vars
phonon-backend-vlc-common
phonon-common
phonon-qt6
phonon-qt6-backend-vlc
pigz
pinentry
pinentry-gnome3
pipewire
pipewire-alsa
pipewire-gstreamer
pipewire-jack-audio-connection-kit
pipewire-jack-audio-connection-kit-libs
pipewire-libs
pipewire-pulseaudio
pipewire-utils
pixman
pkcs11-helper
pkgconf
pkgconf-m4
pkgconf-pkg-config
plasma5support
plasma-activities
plasma-activities-stats
plasma-breeze
plasma-breeze-common
plasma-breeze-qt6
plasma-browser-integration
plasma-desktop
plasma-desktop-doc
plasma-discover
plasma-discover-flatpak
plasma-discover-libs
plasma-discover-notifier
plasma-discover-packagekit
plasma-disks
plasma-integration
plasma-lookandfeel-fedora
plasma-milou
plasma-nm
plasma-nm-l2tp
plasma-nm-openconnect
plasma-nm-openswan
plasma-nm-openvpn
plasma-nm-pptp
plasma-pa
plasma-print-manager
plasma-print-manager-libs
plasma-systemmonitor
plasma-systemsettings
plasma-thunderbolt
plasma-vault
plasma-welcome
plasma-workspace
plasma-workspace-common
plasma-workspace-libs
plasma-workspace-wallpapers
plasma-workspace-wayland
plocate
plymouth
plymouth-core-libs
plymouth-scripts
pnm2ppa
podman
policycoreutils
policycoreutils-python-utils
polkit
polkit-kde
polkit-libs
polkit-pkla-compat
polkit-qt6-1
poppler
poppler-cpp
poppler-data
poppler-qt6
poppler-utils
popt
powerdevil
ppp
pptp
prefixdevname
procps-ng
protobuf-c
psacct
psmisc
pt-sans-fonts
publicsuffix-list-dafsa
pulseaudio-libs
pulseaudio-libs-glib2
pulseaudio-qt-qt6
pulseaudio-utils
python3
python3-attrs
python3-audit
python3-blivet
python3-blockdev
python3-brlapi
python3-bytesize
python3-cairo
python3-cffi
python3-charset-normalizer
python3-cups
python3-dasbus
python3-dateutil
python3-dbus
python3-distro
python3-dnf
python3-dnf-plugins-core
python3-enchant
python3-file-magic
python3-firewall
python3-gobject
python3-gobject-base
python3-gobject-base-noarch
python3-hawkey
python3-idna
python3-inotify
python3-iso639
python3-jsonschema
python3-jsonschema-specifications
python3-kickstart
python3-langtable
python3-libcomps
python3-libdnf
python3-libmount
python3-librepo
python3-libs
python3-libselinux
python3-libsemanage
python3-libstoragemgmt
python3-libxml2
python3-linux-procfs
python3-louis
python3-mako
python3-markupsafe
python3-meh
python3-meh-gui
python3-nftables
python3-packaging
python3-perf
python3-pexpect
python3-pid
python3-pip-wheel
python3-ply
python3-policycoreutils
python3-productmd
python3-ptyprocess
python3-pwquality
python3-pyatspi
python3-pycdio
python3-pycparser
python3-pyparted
python3-pyudev
python3-pyxdg
python3-pyyaml
python3-referencing
python3-regex
python3-requests
python3-requests-file
python3-requests-ftp
python3-rpds-py
python3-rpm
python3-setools
python3-setuptools
python3-simpleline
python3-six
python3-speechd
python3-systemd
python3-urllib3
python3-xkbregistry
python-unversioned-command
qaccessibilityclient-qt6
qca-qt6
qca-qt6-ossl
qcoro-qt6
qemu-guest-agent
qpdf-libs
qqc2-breeze-style
qrencode-libs
qt5-filesystem
qt5-qtbase
qt5-qtbase-common
qt5-qtbase-gui
qt5-qtdeclarative
qt5-qtfeedback
qt5-qtgraphicaleffects
qt5-qtmultimedia
qt5-qtquickcontrols2
qt5-qttranslations
qt5-qtwayland
qt6-filesystem
qt6-qt5compat
qt6-qtbase
qt6-qtbase-common
qt6-qtbase-gui
qt6-qtbase-mysql
qt6-qtdeclarative
qt6-qtimageformats
qt6-qtmultimedia
qt6-qtpdf
qt6-qtpositioning
qt6-qtquick3d
qt6-qtquicktimeline
qt6-qtsensors
qt6-qtserialport
qt6-qtshadertools
qt6-qtspeech
qt6-qtspeech-speechd
qt6-qtsvg
qt6-qttools
qt6-qttools-common
qt6-qttools-libs-designer
qt6-qttranslations
qt6-qtvirtualkeyboard
qt6-qtwayland
qt6-qtwebchannel
qt6-qtwebengine
qt6-qtwebsockets
qt6-qtwebview
qtkeychain-qt6
quota
quota-nls
rav1e-libs
readline
realmd
realtek-firmware
redhat-display-vf-fonts
redhat-mono-vf-fonts
redhat-text-vf-fonts
restore
rit-meera-new-fonts
rit-rachana-fonts
rmt
rootfiles
rpm
rpm-build-libs
rpmfusion-free-release
rpmfusion-nonfree-release
rpm-libs
rpm-plugin-audit
rpm-plugin-selinux
rpm-plugin-systemd-inhibit
rpm-sequoia
rpm-sign-libs
rsvg-pixbuf-loader
rsync
rsyslog
rsyslog-gnutls
rsyslog-gssapi
rsyslog-relp
rtkit
rubberband
samba
samba-client
samba-client-libs
samba-common
samba-common-libs
samba-common-tools
samba-dcerpc
samba-ldb-ldap-modules
samba-libs
samba-usershares
sane-airscan
sane-backends
sane-backends-drivers-cameras
sane-backends-drivers-scanners
sane-backends-libs
sddm
sddm-breeze
sddm-kcm
sddm-wayland-plasma
sdl2-compat
SDL3
sed
selinux-policy
selinux-policy-epel
selinux-policy-epel-targeted
selinux-policy-targeted
serd
setroubleshoot-plugins
setroubleshoot-server
setup
sg3_utils
sg3_utils-libs
sgml-common
shadow-utils
shadow-utils-subid
shared-mime-info
shim-x64
signon
signon-kwallet-extension
signon-plugin-oauth2
signon-qt6
signon-ui
sil-padauk-fonts
skanpage
skopeo
slang
smartmontools
smartmontools-selinux
snappy
socat
sord
sos
sound-theme-freedesktop
soundtouch
source-highlight
soxr
spectacle
speech-dispatcher
speech-dispatcher-espeak-ng
speech-dispatcher-libs
speex
spice-vdagent
spirv-tools-libs
sqlite-libs
squashfs-tools
sratom
srt-libs
sscg
sssd
sssd-ad
sssd-client
sssd-common
sssd-common-pac
sssd-ipa
sssd-kcm
sssd-krb5
sssd-krb5-common
sssd-ldap
sssd-proxy
startup-notification
stix-fonts
stoken-libs
strace
sudo
sudo-python-plugin
svt-av1-libs
svt-hevc-libs
switcheroo-control
symlinks
syslinux
syslinux-extlinux
syslinux-extlinux-nonlinux
syslinux-nonlinux
system-config-printer-libs
system-config-printer-udev
systemd
systemd-libs
systemd-pam
systemd-udev
taglib
tar
tbb
tcpdump
tecla
tesseract
tesseract-langpack-eng
tesseract-tessdata-doc
time
tiwilink-firmware
tmux
toolbox
tpm2-tools
tpm2-tss
tpm2-tss-fapi
tree
tuned
tuned-ppd
twolame-libs
tzdata
uchardet
udisks2
udisks2-iscsi
udisks2-lvm2
unbound-anchor
unbound-libs
unicode-ucd
unity-gtk3-module
unity-gtk-module-common
unzip
upower
upower-libs
urw-base35-bookman-fonts
urw-base35-c059-fonts
urw-base35-d050000l-fonts
urw-base35-fonts
urw-base35-fonts-common
urw-base35-gothic-fonts
urw-base35-nimbus-mono-ps-fonts
urw-base35-nimbus-roman-fonts
urw-base35-nimbus-sans-fonts
urw-base35-p052-fonts
urw-base35-standard-symbols-ps-fonts
urw-base35-z003-fonts
usbmuxd
usbutils
usermode
userspace-rcu
util-linux
util-linux-core
vamp-plugin-sdk
vapoursynth-libs
vazirmatn-vf-fonts
vid.stab
vim-common
vim-data
vim-enhanced
vim-filesystem
vim-minimal
virt-what
vlc-libs
vlc-plugin-ffmpeg
vlc-plugin-gstreamer
vlc-plugin-pipewire
vlc-plugin-pulseaudio
vlc-plugins-base
vlc-plugins-freeworld
vlc-plugins-video-out
vmaf-models
vo-amrwbenc
volume_key-libs
vpnc-script
vulkan-loader
vulkan-tools
vvenc-libs
wavpack
wayland-utils
webrtc-audio-processing
wget
which
wireless-regdb
wireplumber
wireplumber-libs
words
wpa_supplicant
x264-libs
x265-libs
xapian-core-libs
xcb-util
xcb-util-cursor
xcb-util-image
xcb-util-keysyms
xcb-util-renderutil
xcb-util-wm
xdg-dbus-proxy
xdg-desktop-portal
xdg-desktop-portal-gtk
xdg-desktop-portal-kde
xdg-user-dirs
xdg-utils
xdpyinfo
xfsdump
xfsprogs
xhost
xkbcomp
xkeyboard-config
xl2tpd
xmessage
xml-common
xmlsec1
xmlsec1-openssl
xorg-x11-server-Xwayland
xorriso
xprop
xrdb
xsettingsd
xvidcore
xwaylandvideobridge
xxd
xz
xz-libs
xz-lzma-compat
yum
zenity
zeromq
zimg
zip
zix
zlib-ng-compat
zstd
zvbi
zxing-cpp

%end
